/*  Berechnet den Standardwert für den Beginn des Zeitfensters für die Ausschaltzeiten.

    Das Zeitfenster der Ausschalten sollen für alle KSVBA-Ressourcen gleich sein. Damit lassen sich AGe immer ohne Fehler von
    einer Ressource auf eine andere verschieben.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__renew_offtime', 'scheduling', _commit => true );  -- Funktion resource_timeline__offtime__default_timeframe_start__get() ist abhängig von Funktion resource_timeline__renew_offtime().
SELECT tsystem.function__drop_by_regex( 'resource_timeline__offtime__default_timeframe_start__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__offtime__default_timeframe_start__get(
  ) RETURNS timestamp AS $$

  DECLARE
      _min_ag_start             timestamp;                                                                                      -- Beginn des frühesten AG.
      _min_buffer_days_in_past  constant integer := TSystem.Settings__GetInteger( 'scheduling.min_buffer_days_in_past', 1 );    -- Ausschaltzeiten sollen immer mindestens 1 Tag vor Beginn des frühesten AG in die Vergangenheit existieren.
      _min_days_in_past         constant integer := TSystem.Settings__GetInteger( 'scheduling.min_days_in_past', 90 );          -- Ausschaltzeiten sollen immer mindestens 3 Monate in die Vergangenheit existieren.
      _result                   timestamp;                                                                                      -- Das Ergebnis.

  BEGIN
      -- Den Start des frühesten AG in der Timeline finden.
      _min_ag_start := min( ti_date_start )
                  FROM scheduling.resource_timeline
                 WHERE ti_a2_id IS NOT null;

      _result :=
          least (
                    date_trunc( 'day', _min_ag_start ) - interval '1 day' * _min_buffer_days_in_past    -- Entweder ab 1 Tag vor Beginn des frühesten AG in der Vergangenheit oder ...
                  , date_trunc( 'day', now() ) - interval '1 day' * _min_days_in_past                   -- ... ab 3 Monate in der Vergangenheit sollen Ausschaltzeiten generiert werden. ...
                )                                                                                       -- ... Je nachdem, was kleiner (weiter in Vergangenheit) ist.
      ;

      RETURN _result;

  END $$ language plpgsql;